#include "StdV3D.h"
#include "ScanLines.h"


namespace V3D {



//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



void OneLineScansArray::Affiche() const
{
//	ScanLineArray::const_iterator it;
//	for( it = m_aRanges.begin(); it != m_aRanges.end(); ++it)
//	{
//		if( it != m_aRanges.begin() )
//			DKTRACE( " ==> " );
//		DKTRACE( "[ %d, %d ]", it->nRangeBeg, it->nRangeEnd  );
//	}
//	DKTRACE( "\n" );
}

						//////////////////////////


void  OneLineScansArray::AddScan( const ScanLineRange& range) 
{
#ifdef _DEBUG
	const ScanLineArray aRangesCopy = m_aRanges;
#endif

	assert( range.nRangeBeg <= range.nRangeEnd );
	int32 nScansCount = m_aRanges.size();
	// Cas le plus simple : ligne vide
	if( nScansCount == 0)
	{
		m_aRanges.push_back(range);
	}
	// Cas assez simple : ligne contenant un unique intervalle : se resout simplement...
	else if (nScansCount == 1)
	{
		// Si les intervalles s'entrecoupent : l'intervalle unique existant est simplement elargi
		// Sinon l'intervalle a inserer est ajoute dans le tableau
		if( ! m_aRanges[0].MergeOnIntersection(range) )
		{
			if( range.nRangeBeg < m_aRanges[0].nRangeBeg) // Insertion en tete si avant
				m_aRanges.insert(m_aRanges.begin(), range);
			else                                          // Insertion en fin si apres
				m_aRanges.push_back(range);
		}
	}
	// Cas plus compliques -> traitement generique
	else
	{
		using namespace std;
		// recherche de l'emplacement ou inserer dans la ligne :
		//     premier intervalle pas completement avant range
		ScanLineArray::iterator itInser = find_if( m_aRanges.begin(), m_aRanges.end(), not1(bind2nd(less<ScanLineRange>(), range)));

		// Cas ou le nouvel intervalle ne touche pas les intervalles de la ligne, on l'insere
		if( itInser == m_aRanges.end() || itInser->IsAfter(range) )
		{
			m_aRanges.insert(itInser, range);
		}
		// Sinon, travail de fusionnage a realiser
		else
		{
			bool bMerged = itInser->MergeOnIntersection( range );
			if( !bMerged )
			{
				assert( 0 );
			}
			
			ScanLineArray::iterator itMerge = itInser+1;
			ScanLineArray::iterator itEnd   = m_aRanges.end();
			while( itMerge != itEnd && itInser->MergeOnIntersection( *itMerge ) )
				++itMerge;

#if 0
			m_aRanges.erase( itInser + 1, itMerge );
#else
			ScanLineArray::iterator itDest = itInser+1;
			while( itMerge != itEnd )
				*itDest++ = *itMerge++;
			m_aRanges.resize( (itDest - m_aRanges.begin()) );
#endif
		}

	}

#ifdef _DEBUG    // Verification de la coherence
	
	// Il faudra retrouver l'intervalle fraichement ajoute dans la ligne.
	bool bFoundInputRange = false;
	
	for( uint32 idbg = 0; idbg < m_aRanges.size(); ++idbg)
	{
		const ScanLineRange& cur1 = m_aRanges[idbg];
		
		// La fin d'un scan doit etre sur ou apres son debut!
		assert( cur1.nRangeBeg <= cur1.nRangeEnd );

		// Test d'inclusion du scan ajoute dans le scan courant
		if( (range.nRangeBeg >= cur1.nRangeBeg && range.nRangeEnd <= cur1.nRangeEnd) )
			bFoundInputRange = true;

		// Test de coherence entre le scan courant et le suivant
		if( idbg < m_aRanges.size()-1)
		{
			const ScanLineRange& cur2 = m_aRanges[idbg+1];
			
			assert( cur2.nRangeBeg <= cur2.nRangeEnd ); // coherence du suivant : fin apres debut
			assert( cur1.nRangeEnd < cur2.nRangeBeg-1); // debut du suivant apres fin du courant
		}
	}
	assert( bFoundInputRange );

	// Verification de l'inclusion de chaque scanline de la ligne originale dans la ligne apres insertion
	for( uint32 idbg = 0; idbg < aRangesCopy.size(); ++idbg)
	{
		bool bFoundInputRange = false;
		const ScanLineRange& scanToFind = aRangesCopy[idbg];

		for( uint32 idbg2 = 0; idbg2 < m_aRanges.size(); ++idbg2)
		{
			const ScanLineRange& cur = m_aRanges[idbg2];
			if( (scanToFind.nRangeBeg >= cur.nRangeBeg && scanToFind.nRangeEnd <= cur.nRangeEnd) )
				bFoundInputRange = true;
		}
		assert( bFoundInputRange );
	}
#endif
}

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

void AllScansArray::ReInit()
{
	int32 nLinesScansCount = m_slLines.GetNbScans();
	for( int32 nCurLineScanIdx = 0; nCurLineScanIdx < nLinesScansCount; ++nCurLineScanIdx)
	{
		const ScanLineRange& curLineScanRange = m_slLines[nCurLineScanIdx];
		int32 nBegY = curLineScanRange.nRangeBeg;
		int32 nEndY = std::min( int32(m_aScanLines.size()-1), curLineScanRange.nRangeEnd);
		for( int32 nCurY = nBegY; nCurY <= nEndY; ++nCurY)
		{
			OneLineScansArray& curLine = m_aScanLines[nCurY];
			curLine.ReInit();
		}
	}
	m_slLines.ReInit();
}
						//////////////////////////

AllScansArray::AllScansArray()
{
}
						//////////////////////////

void AllScansArray::AddRectangle( const ScanLineRange& rangeX, const ScanLineRange& rangeY)
{
	m_slLines.AddScan( rangeY );
	int32 nBegY = rangeY.nRangeBeg;
	int32 nEndY = rangeY.nRangeEnd;
	for( int32 n = nBegY ; n <= nEndY; ++n)
		m_aScanLines[n].AddScan( rangeX );
}
						//////////////////////////


} // namespace

